package cn.breeze.elleai.application.dto.langchain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author yangyw
 */
@Data
@Schema(description = "向量存储的文本片段")
public class VectorSegment implements Serializable {

    @Schema(description = "文本内容")
    private String content;

    @Schema(description = "存储片段id")
    private String id;

    @Schema(description = "元数据")
    private Map<String,?> metadata;

    @Schema(description = "相似度")
    private Double score;

    @Schema(description = "重排后的相似度")
    private Double relevanceScore;
}
