package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineRequestDto implements Serializable {

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo = 1;

    @Schema(description = "分页数量")
    @JsonProperty("page_size")
    private Integer pageSize = 10;

    @Schema(description = "对练名称")
    private String name;

    @Schema(description = "场景ID")
    @JsonProperty("scene_id")
    private Integer sceneId;

    @Schema(description = "场景分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    @Schema(description = "开始时间")
    @JsonProperty("start_time")
    private Date startTime;

    @Schema(description = "结束时间")
    @JsonProperty("end_time")
    private Date endTime;
}
