package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class KbRequestDto implements Serializable {

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo = 1;

    @Schema(description = "分页数量")
    @JsonProperty("page_size")
    private Integer pageSize = 10;

    @Schema(description = "名称")
    private String name;

    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    @Schema(description = "分类ID")
    @JsonProperty("tag_id")
    private Integer tagId;

}
