package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ProperNounSaveDto implements Serializable {

    @Schema(description = "专有名词ID")
    private Integer id;

    /**
     * 专有名词名称
     */
    @Schema(description = "专有名词名称")
    private String name;

    /**
     * 中文拼音
     */
    @Schema(description = "中文拼音")
    private String pinyin;

    @Schema(description = "相似词列表")
    @JsonProperty("similar_word_list")
    private List<String> similarWordList;

    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

}
