package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class WikiRequestDto implements Serializable {

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo = 1;

    @Schema(description = "分页数量")
    @JsonProperty("page_size")
    private Integer pageSize = 10;

    @Schema(description = "资料名称")
    private String name;

    @Schema(description = "知识库分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    @Schema(description = "知识库分类ID")
    @JsonProperty("wiki_category_id")
    private Integer wikiCategoryId;

    @Schema(description = "场景分类ID")
    @JsonProperty("scene_category_id")
    private Integer sceneCategoryId;

    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;
}
