package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineDetailRecordMobileDto implements Serializable {

    @Schema(description = "对练记录明细ID")
    private Integer id;

    /**
     * 对练记录ID
     */
    @Schema(description = "对练记录ID")
    @JsonProperty("record_id")
    private Integer recordId;

    /**
     * 题目ID
     */
    @Schema(description = "题目ID")
    @JsonProperty("qa_id")
    private Integer qaId;

    /**
     * 题目
     */
    @Schema(description = "题目")
    private String question;

    /**
     * 标准答案
     */
    @Schema(description = "标准答案")
    private String answer;

    /**
     * 员工答案
     */
    @Schema(description = "用户答案")
    @JsonProperty("user_answer")
    private String userAnswer;

    /**
     * 评分
     */
    @Schema(description = "评分")
    private Float score;

    /**
     * 评价
     */
    @Schema(description = "评价")
    private String evaluation;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    private Date updateTime;
}
