package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class ExamineMobileDto implements Serializable {

    @Schema(description = "对练ID")
    private Integer id;

    /**
     * 对练名称
     */
    @Schema(description = "对练名称")
    private String name;

    /**
     * 对练描述
     */
    @Schema(description = "对练描述")
    private String description;

    /**
     * 海报图
     */
    @Schema(description = "海报图")
    private String poster;

    /**
     * 题目数量
     */
    @Schema(description = "题目数量")
    @JsonProperty("qa_num")
    private Integer qaNum;

    /**
     * 已考试次数
     */
    @Schema(description = "已考试次数")
    @JsonProperty("exam_total_count")
    private long examTotalCount;

    /**
     * 是否参与考试
     */
    @Schema(description = "是否参加考试")
    @JsonProperty("exam_flag")
    private boolean examFlag;


    /**
     * 练习次数
     */
    @Schema(description = "练习次数")
    @JsonProperty("practice_count")
    private long practiceCount;

    /**
     * 对练次数
     */
    @Schema(description = "对练次数")
    @JsonProperty("exam_count")
    private long examCount;

    /**
     * 最高综合评分
     */
    @Schema(description = "最高综合评分")
    @JsonProperty("max_overall_score")
    private double maxOverallScore;
}
