package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineQaDifyDto implements Serializable {

    @Schema(description = "题目ID")
    @JsonProperty("question_id")
    private Integer questionId;

    /**
     * 问题
     */
    @Schema(description = "问题")
    private String question;

    /**
     * 答案
     */
    @Schema(description = "标准答案")
    private String answer;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类名称")
    @JsonProperty("category_name")
    private String categoryName;

    /**
     * 对练分类ID
     */
    @Schema(description = "DIFY字段")
    private String project;

    /**
     * 对练分类ID
     */
    @Schema(description = "DIFY字段")
    private String code;

    /**
     * dify 节点字段
     */
    @Schema(description = "DIFY字段")
    private boolean next;
}
