package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineQaDto implements Serializable {

    @Schema(description = "题目ID")
    private Integer id;

    /**
     * 问题
     */
    @Schema(description = "问题")
    private String question;

    /**
     * 答案
     */
    @Schema(description = "答案")
    private String answer;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类名称")
    @JsonProperty("category_name")
    private String categoryName;


    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;
}
