package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Date;
import java.util.List;

@Data
public class ExamineRecordDto implements Serializable {

    @Schema(description = "对练记录ID")
    private Integer id;

    /**
     * 用户ID
     */
    @Schema(description = "用户ID")
    @JsonProperty("user_id")
    private String userId;

    /**
     * 用户名称
     */
    @Schema(description = "用户名称")
    @JsonProperty("user_name")
    private String userName;

    /**
     * 会话ID
     */
    @Schema(description = "会话ID")
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 对练ID
     */
    @Schema(description = "对练ID")
    @JsonProperty("examine_id")
    private Integer examineId;

    @Schema(description = "对练名称")
    @JsonProperty("examine_name")
    private String examineName;

    @Schema(description = "对练描述")
    @JsonProperty("examine_description")
    private String examineDescription;

    /**
     * 对练模式（0练习 1对练）
     */
    @Schema(description = "对练模式（0练习 1对练）")
    @JsonProperty("examine_mode")
    private Integer examineMode;

    /**
     * 已答题数量
     */
    @Schema(description = "已答题数量")
    @JsonProperty("answered_num")
    private Integer answeredNum;

    /**
     * 题目总数
     */
    @Schema(description = "题目总数")
    @JsonProperty("qaNum")
    private Integer qaNum;

    /**
     * 综合评分
     */
    @Schema(description = "综合评分")
    @JsonProperty("overall_score")
    private Float overallScore;

    /**
     * 综合评价
     */
    @Schema(description = "综合评价")
    @JsonProperty("overall_evaluation")
    private String overallEvaluation;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    private Date updateTime;

    /**
     * 答题明细
     */
    @Schema(description = "答题明细列表")
    @JsonProperty("details")
    private List<ExamineDetailRecordMobileDto> details;
}
