package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class ExamineResultDto implements Serializable {

    @Schema(description = "问题")
    private String question;

    @Schema(description = "标准答案")
    private String answer;

    @Schema(description = "用户答案")
    @JsonProperty("user_answer")
    private String userAnswer;

    @Schema(description = "评分")
    @JsonProperty("score")
    private Double score;

    @Schema(description = "得分点评")
    @JsonProperty("score_criteria")
    private String scoreCriteria;

    @Schema(description = "题目ID")
    @JsonProperty("question_id")
    private Integer questionId;

}
