package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExamineSceneCategoryDto implements Serializable {

    @Schema(description = "场景分类ID")
    private Integer id;

    /**
     * 分类名称
     */
    @Schema(description = "场景分类名称")
    private String name;

    /**
     * 场景ID
     */
    @Schema(description = "场景ID")
    @JsonProperty("scene_id")
    private Integer sceneId;

    /**
     * 场景名称
     */
    @Schema(description = "场景名称")
    @JsonProperty("scene_name")
    private String sceneName;

    @Schema(description = "可见角色列表")
    @JsonProperty("visible_role_ids")
    private List<String> visibleRoleList;

    /**
     * 分类描述
     */
    @Schema(description = "场景分类描述")
    private String description;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    private Date updateTime;

    /**
     * 父级分类ID
     */
    @Schema(description = "父级ID")
    @JsonProperty("parent_id")
    private Integer parentId;
}
