package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UserChatCompletionHistoryDto implements Serializable {

    @Schema(description = "会话历史ID")
    private Integer id;

    /**
     * 会话ID
     */
    @Schema(description = "会话记录ID")
    @JsonProperty("chat_completion_id")
    private Integer chatCompletionId;

    /**
     * 类型（0用户提问 1AI回答）
     */
    @Schema(description = "类型（0用户提问 1AI回答）")
    private Integer type;

    /**
     * 内容
     */
    @Schema(description = "内容")
    private String content;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;
}
