package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class WikiListMobileDto implements Serializable {

    @Schema(description = "资料ID")
    private Integer id;

    /**
     * 资料名称
     */
    @Schema(description = "资料名称")
    private String name;

    /**
     * 资料描述
     */
    @Schema(description = "资料描述")
    private String description;

    /**
     * 资料分类ID
     */
    @Schema(description = "资料分类ID")
    @JsonProperty("wiki_category_id")
    private Integer wikiCategoryId;

    /**
     * 资料分类名称
     */
    @Schema(description = "资料分类名称")
    @JsonProperty("wiki_category_name")
    private String wikiCategoryName;

    @Schema(description = "浏览次数")
    @JsonProperty("view_count")
    private String viewCount;

    @Schema(description = "是否浏览")
    @JsonProperty("view_flag")
    private boolean viewFlag;
}
