package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class WikiMobileDto implements Serializable {

    @Schema(description = "资料ID")
    private Integer id;

    /**
     * 资料名称
     */
    @Schema(description = "资料名称")
    private String name;

    /**
     * 资料描述
     */
    @Schema(description = "资料描述")
    private String description;

    /**
     * 资料海报图
     */
    @Schema(description = "海报图")
    private String poster;

    /**
     * 资料文件URL
     */
    @Schema(description = "资料文件URL")
    @JsonProperty("file_url")
    private String fileUrl;

    /**
     * 资料分类名称
     */
    @Schema(description = "资料分类名称")
    @JsonProperty("wiki_category_name")
    private String wikiCategoryName;

    /**
     * 场景分类ID
     */
    @Schema(description = "场景分类ID")
    @JsonProperty("scene_category_id")
    private String sceneCategoryId;

    /**
     * 场景分类名称
     */
    @Schema(description = "场景分类名称")
    @JsonProperty("scene_category_name")
    private String sceneCategoryName;

    /**
     * 富文本详情
     */
    @Schema(description = "富文本详情")
    private String detail;
}
