package cn.breeze.elleai.config;

import cn.hutool.core.bean.BeanUtil;
import cn.smartbreeze.core.file.client.MinioFileClient;
import cn.smartbreeze.core.file.props.FileProperties;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class MinioConfig {

    @Autowired
    private MinioFileProperties fileProperties;

    @Bean
    public MinioClient minioClient() {
        return MinioClient.builder()
                .endpoint(fileProperties.getEndpoint())
                .credentials(fileProperties.getSecretId(), fileProperties.getSecretKey())
                .build();
    }

    @Bean
    public MinioFileClient privateFileClient() {
        return new MinioFileClient(getFileProperties(), minioClient());
    }

    @Bean
    @Primary
    public MinioFileClient minioFileClient( MinioClient minioClient) {
        return new MinioFileClient(getFileProperties(), minioClient);
    }

    private FileProperties getFileProperties() {
        FileProperties properties = new FileProperties();
        BeanUtil.copyProperties(fileProperties, properties);
        return properties;
    }

}
