package cn.breeze.elleai.config;

import cn.smartbreeze.core.file.config.StoreType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(
        prefix = "minio-file"
)
@EnableConfigurationProperties
@Configuration
@Data
public class MinioFileProperties {
    private StoreType store;
    private String bucket;
    private String secretId;
    private String secretKey;
    private String endpoint;
    private String uploadPrefix = "";
    private String domainPrefix;
    private String region = "default";
    private String downloadUrlPrefix;
}
