package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.request.PageRequest;
import cn.breeze.elleai.application.dto.request.UserLoginRequest;
import cn.breeze.elleai.application.dto.response.PagePermissionResult;
import cn.breeze.elleai.application.dto.response.UserLoginResult;
import cn.breeze.elleai.domain.sparring.model.response.SysUserResponseModel;
import cn.breeze.elleai.domain.system.service.SysUserService;
import cn.breeze.elleai.exception.InternalException;
import cn.breeze.elleai.util.IkMD5Utils;
import cn.breeze.elleai.util.JwtUtil;
import cn.breeze.elleai.util.UserPrincipal;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 *
 * 系统登录
 * @author Administrator
 */
@RestController
@Tag(name = "登录认证")
@Slf4j
@RequestMapping(value = "/admin")
@RequiredArgsConstructor
public class AuthController {

    private final SysUserService sysUserService;

    @Operation(summary = "用户登录")
    @PostMapping(value = "/oauth/login")
    public ApiResponse<UserLoginResult> login(@RequestBody UserLoginRequest request) {
        UserLoginResult result = new UserLoginResult();

        SysUserResponseModel user = sysUserService.findByUsername(request.getUserName());
        if (ObjectUtil.isNull(user)) {
            log.error("账号:{},不存在！", request.getUserName());
            throw new InternalException(1000, "用户不存在");
        }
        if (!StrUtil.equals(user.getPassword(), IkMD5Utils.md5(request.getPassword()))) {
            throw new InternalException(1000, "账号或密码错误");
        }

        String token = JwtUtil.generateToken(request.getUserName(), request.getPassword(), user.getId());
        result.setToken(token);
        result.setUserName(request.getUserName());
        result.setNickName(user.getNickName());
        result.setAvatar(user.getAvatar());
        result.setUserId(String.valueOf(user.getId()));

        return ApiResponse.ok(result);
    }

    @Operation(summary = "用户登出")
    @PostMapping(value = "/oauth/logout")
    public ApiResponse<String> logout(UserPrincipal userPrincipal) {
        return ApiResponse.ok("success");
    }

    @Operation(summary = "登录用户信息")
    @GetMapping(value = "/user/login_user_info")
    public ApiResponse<UserLoginResult> loginUserInfo(UserPrincipal userPrincipal) {
        UserLoginResult result = new UserLoginResult();
        result.setToken(userPrincipal.getToken());
        result.setUserName(userPrincipal.getUserName());
        result.setNickName(userPrincipal.getUserName());
        result.setUserId(userPrincipal.getUserId());
        return ApiResponse.ok(result);
    }

    @Operation(summary = "获取用户-页面")
    @PostMapping(value = "/page/get_user_page")
    public ApiResponse<PagePermissionResult> getUserPage(UserPrincipal principal, @RequestBody PageRequest request) {
        String json = "{\n" +
                "        \"type\": 709394,\n" +
                "        \"channels\": [\n" +
                "            \"/test\",\n" +
                "            \"/user\",\n" +
                "            \"/admin/permission\",\n" +
                "            \"/admin/roles\",\n" +
                "            \"/admin/roles/modify/:id\",\n" +
                "            \"/admin/pages\",\n" +
                "            \"/collect/edit/:type/:id\",\n" +
                "            \"/collect\",\n" +
                "            \"/collect/report\",\n" +
                "            \"/collect/detail/:id\",\n" +
                "            \"/login\",\n" +
                "            \"/sys/department\",\n" +
                "            \"/sys/position\",\n" +
                "            \"/profile/list\",\n" +
                "            \"/profile/role\",\n" +
                "            \"/market\",\n" +
                "            \"/market/report/:id\",\n" +
                "            \"/market/detail/:id/:status\",\n" +
                "            \"/market/invite/:id\",\n" +
                "            \"/profile/list/detail/:id/:status\",\n" +
                "            \"/profile/labelset\",\n" +
                "            \"/page/get_user_page\",\n" +
                "            \"/logout\",\n" +
                "            \"/user/list\",\n" +
                "            \"/profile/schedule\",\n" +
                "            \"/profile/examine\",\n" +
                "            \"/profile/examine/detail/:id/:status/:xrefId\",\n" +
                "            \"/report/imaging\",\n" +
                "            \"/sys/permission\",\n" +
                "            \"/profile/transfer\",\n" +
                "            \"/client/verbal-trick\",\n" +
                "            \"/client/tag-list\",\n" +
                "            \"/client/jargon-type\",\n" +
                "            \"/client/user-portrait\",\n" +
                "            \"/client\",\n" +
                "            \"/doctor\",\n" +
                "            \"/test\",\n" +
                "            \"/user\",\n" +
                "            \"/admin/permission\",\n" +
                "            \"/admin/roles\",\n" +
                "            \"/admin/roles/modify/:id\",\n" +
                "            \"/admin/pages\",\n" +
                "            \"/login\",\n" +
                "            \"/sys/department\",\n" +
                "            \"/sys/position\",\n" +
                "            \"/page/get_user_page\",\n" +
                "            \"/logout\",\n" +
                "            \"/report/imaging/detail\",\n" +
                "            \"/report/invite\",\n" +
                "            \"/report/invite/detail\",\n" +
                "            \"/scene_category\"\n" +
                "        ],\n" +
                "        \"permission\": {\n" +
                "            \"/user/list\": [\n" +
                "                \"add\",\n" +
                "                \"edit\",\n" +
                "                \"add_tag\"\n" +
                "            ],\n" +
                "            \"/sys/permission\": [\n" +
                "                \"add\",\n" +
                "                \"delete\",\n" +
                "                \"switch\",\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/client/verbal-trick\": [\n" +
                "                \"jargon-add\",\n" +
                "                \"jargon-edit\",\n" +
                "                \"jargon-delete\",\n" +
                "                \"keyword-add\",\n" +
                "                \"keyword-edit\",\n" +
                "                \"keyword-delete\",\n" +
                "                \"keyword-switch\"\n" +
                "            ],\n" +
                "            \"/profile/examine\": [\n" +
                "                \"pass\",\n" +
                "                \"reject\"\n" +
                "            ],\n" +
                "            \"/test\": [\n" +
                "                \"test\",\n" +
                "                \"/\",\n" +
                "                \"children\"\n" +
                "            ],\n" +
                "            \"/collect/detail/:id\": [\n" +
                "                \"export\"\n" +
                "            ],\n" +
                "            \"/sys/position\": [\n" +
                "                \"add\",\n" +
                "                \"switch\",\n" +
                "                \"delete\",\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/profile/role\": [\n" +
                "                \"add\"\n" +
                "            ],\n" +
                "            \"/admin/pages\": [\n" +
                "                \"add\",\n" +
                "                \"switch\",\n" +
                "                \"delete\",\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/market/report/:id\": [\n" +
                "                \"export\"\n" +
                "            ],\n" +
                "            \"/client/user-portrait\": [\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/admin/roles\": [\n" +
                "                \"add\",\n" +
                "                \"switch\",\n" +
                "                \"delete\",\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/profile/list/detail/:id/:status\": [\n" +
                "                \"user-modify\",\n" +
                "                \"require-modify\"\n" +
                "            ],\n" +
                "            \"/profile/list\": [\n" +
                "                \"export\",\n" +
                "                \"upload\",\n" +
                "                \"modify-contact\",\n" +
                "                \"batch-modify\",\n" +
                "                \"user-modify\",\n" +
                "                \"require-modify\",\n" +
                "                \"create\"\n" +
                "            ],\n" +
                "            \"/profile/labelset\": [\n" +
                "                \"modify\",\n" +
                "                \"delete\",\n" +
                "                \"add\",\n" +
                "                \"edit\"\n" +
                "            ],\n" +
                "            \"/admin/permission\": [\n" +
                "                \"ban\",\n" +
                "                \"unban\",\n" +
                "                \"delete\",\n" +
                "                \"edit\",\n" +
                "                \"disposition\",\n" +
                "                \"add\",\n" +
                "                \"editpwd\"\n" +
                "            ],\n" +
                "            \"/profile/schedule\": [\n" +
                "                \"add\",\n" +
                "                \"edit\",\n" +
                "                \"delete\"\n" +
                "            ],\n" +
                "            \"/sys/department\": [\n" +
                "                \"add\",\n" +
                "                \"switch\",\n" +
                "                \"delete\",\n" +
                "                \"edit\",\n" +
                "                \"person-list\",\n" +
                "                \"person-add\",\n" +
                "                \"person-delete\",\n" +
                "                \"person-edit\",\n" +
                "                \"batch-edit\",\n" +
                "                \"batch-delete\"\n" +
                "            ],\n" +
                "            \"/collect\": [\n" +
                "                \"add\",\n" +
                "                \"edit\",\n" +
                "                \"delete\",\n" +
                "                \"switch\",\n" +
                "                \"detail\"\n" +
                "            ],\n" +
                "            \"/admin/roles/modify/:id\": [\n" +
                "                \"addPage\"\n" +
                "            ],\n" +
                "            \"/market\": [\n" +
                "                \"add\",\n" +
                "                \"edit\",\n" +
                "                \"delete\",\n" +
                "                \"switch\",\n" +
                "                \"detail\",\n" +
                "                \"copy\"\n" +
                "            ],\n" +
                "            \"/profile/examine/detail/:id/:status/:xrefId\": [\n" +
                "                \"pass\",\n" +
                "                \"reject\"\n" +
                "            ],\n" +
                "            \"/client/jargon-type\": [\n" +
                "                \"add\",\n" +
                "                \"edit\",\n" +
                "                \"delete\"\n" +
                "            ],\n" +
                "            \"/market/invite/:id\": [\n" +
                "                \"export\"\n" +
                "            ],\n" +
                "            \"/client/tag-list\": [\n" +
                "                \"tag-add\",\n" +
                "                \"tag-edit\",\n" +
                "                \"tag-delete\",\n" +
                "                \"tag-select\",\n" +
                "                \"tag-contact\",\n" +
                "                \"keyword-add\",\n" +
                "                \"keyword-edit\",\n" +
                "                \"keyword-delete\",\n" +
                "                \"keyword-switch\"\n" +
                "            ]\n" +
                "        }" +
                "}";
        return ApiResponse.ok(JSONObject.parseObject(json, PagePermissionResult.class));
    }
}
