package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.QaAssistantRequestDto;
import cn.breeze.elleai.application.dto.request.QaAssistantSaveDto;
import cn.breeze.elleai.application.dto.request.UserQaRequestDto;
import cn.breeze.elleai.application.dto.response.QaAssistantDto;
import cn.breeze.elleai.application.dto.response.UserChatCompletionDto;
import cn.breeze.elleai.application.dto.response.UserChatCompletionHistoryDto;
import cn.breeze.elleai.application.service.AppChatCompletionService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;



@RestController
@RequestMapping(value = "/admin/chat")
@Tag(name = "管理端-AI问答相关", description = "AI问答相关")
@RequiredArgsConstructor
public class ChatCompletionController {

    private final AppChatCompletionService chatCompletionService;


    @Operation(summary = "助手详情")
    @GetMapping("/assistant/detail/{id}")
    public ApiResponse<QaAssistantDto> qaAssistantDetail(@Schema(description = "助手ID") @PathVariable("id") Integer id) {
        QaAssistantDto detail = chatCompletionService.qaAssistantDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用助手")
    @PostMapping("/assistant/update_status/{id}/{status}")
    public ApiResponse<String> updateQaAssistantStatus(@Schema(description = "助手ID") @PathVariable("id") Integer id,
                                                       @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        chatCompletionService.updateQaAssistantStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除助手")
    @PostMapping("/assistant/delete/{id}")
    public ApiResponse<String> deleteQaAssistant(@Schema(description = "助手ID") @PathVariable("id") Integer id) {
        chatCompletionService.deleteQaAssistant(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存助手")
    @PostMapping("/assistant/save")
    public ApiResponse<String> saveOrUpdateQaAssistant(@RequestBody QaAssistantSaveDto dto) {
        chatCompletionService.saveQaAssistant(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "助手列表")
    @GetMapping("/assistant/list")
    public ApiResponse<PageResult<QaAssistantDto>> list(@QueryParam QaAssistantRequestDto request) {
        PageResult<QaAssistantDto> pageResult = chatCompletionService.qaAssistantPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }


    @Operation(summary = "AI问答会话详情")
    @GetMapping("/user/detail/{session_id}")
    public ApiResponse<List<UserChatCompletionHistoryDto>> userQaDetail(@Schema(description = "会话记录ID") @PathVariable("session_id") Integer sessionId) {
        List<UserChatCompletionHistoryDto> detail = chatCompletionService.userQaDetail(sessionId);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "AI问答会话列表")
    @GetMapping("/user/list")
    public ApiResponse<PageResult<UserChatCompletionDto>> userQaList(@QueryParam UserQaRequestDto request) {
        PageResult<UserChatCompletionDto> pageResult = chatCompletionService.userQaPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
