package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ExamineSceneCategoryRequestDto;
import cn.breeze.elleai.application.dto.request.ExamineSceneCategorySaveDto;
import cn.breeze.elleai.application.dto.response.ExamineSceneCategoryDto;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * 场景分类
 */
@RestController
@RequestMapping(value = "/admin/examine/scene_category")
@Tag(name = "管理端-对练场景分类", description = "对练场景分类")
@RequiredArgsConstructor
public class ExamineSceneCategoryController {

    private final AppExamineService examineService;


    @Operation(summary = "对练场景分类详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<ExamineSceneCategoryDto> detail(@Schema(description = "场景分类ID") @PathVariable("id") Integer id) {
        ExamineSceneCategoryDto detail = examineService.sceneCategoryDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用对练场景分类")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "场景分类ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateSceneCategoryStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除对练场景分类")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "场景分类ID") @PathVariable("id") Integer id) {
        examineService.deleteSceneCategory(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存对练场景分类")
    @PostMapping("/save")
    public ApiResponse<String> save(@RequestBody ExamineSceneCategorySaveDto dto) {
        examineService.saveExamineSceneCategory(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "对练场景分类列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<ExamineSceneCategoryDto>> list(@QueryParam ExamineSceneCategoryRequestDto request) {
        PageResult<ExamineSceneCategoryDto> pageResult = examineService.examineSceneCategoryPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
