package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ExamineSceneRequestDto;
import cn.breeze.elleai.application.dto.request.ExamineSceneSaveDto;
import cn.breeze.elleai.application.dto.response.ExamineSceneDto;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * 场景
 */
@RestController
@RequestMapping(value = "/admin/examine/scene")
@Tag(name = "管理端-对练场景", description = "对练场景")
@RequiredArgsConstructor
public class ExamineSceneController {

    private final AppExamineService examineService;


    @Operation(summary = "对练场景详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<ExamineSceneDto> detail(@Schema(description = "场景ID") @PathVariable("id") Integer id) {
        ExamineSceneDto detail = examineService.sceneDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用对练场景")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "场景ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateSceneStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除对练场景")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "场景ID") @PathVariable("id") Integer id) {
        examineService.deleteScene(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存对练场景")
    @PostMapping("/save")
    public ApiResponse<String> save(@RequestBody ExamineSceneSaveDto dto) {
        examineService.saveExamineScene(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "对练场景列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<ExamineSceneDto>> list(@QueryParam ExamineSceneRequestDto request) {
        PageResult<ExamineSceneDto> pageResult = examineService.examineScenePaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
