package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.KbRequestDto;
import cn.breeze.elleai.application.dto.request.KbSaveDto;
import cn.breeze.elleai.application.dto.request.WikiCategoryRequestDto;
import cn.breeze.elleai.application.dto.request.WikiCategorySaveDto;
import cn.breeze.elleai.application.dto.response.KbDto;
import cn.breeze.elleai.application.dto.response.WikiCategoryDto;
import cn.breeze.elleai.application.service.AppKbService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/admin/kb")
@Tag(name = "管理端-知识库", description = "知识库")
@RequiredArgsConstructor
public class KbController {

    private final AppKbService kbService;
    
    @Operation(summary = "知识库详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<KbDto> detail(@Schema(description = "知识库ID") @PathVariable("id") Integer id) {
        KbDto detail = kbService.kbDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用知识库")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "知识库ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        kbService.updateKbStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除知识库")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "知识库ID") @PathVariable("id") Integer id) {
        kbService.deleteKb(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存知识库")
    @PostMapping("/save")
    public ApiResponse<String> saveOrUpdate(@RequestBody KbSaveDto dto) {
        kbService.saveKb(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "知识库列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<KbDto>> list(@QueryParam KbRequestDto request) {
        PageResult<KbDto> pageResult = kbService.kbPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "向量数据初始化")
    @GetMapping("/sync_store")
    public ApiResponse<String> syncStore(){
        kbService.syncStore();
        return ApiResponse.ok("SUCCESS");
    }

//    @Operation(summary = "知识库分类详情")
//    @GetMapping("/tag/detail/{id}")
//    public ApiResponse<WikiCategoryDto> categoryDetail(@Schema(description = "知识库分类ID") @PathVariable("id") Integer id) {
//        WikiCategoryDto detail = examineService.wikiCategoryDetail(id);
//        return ApiResponse.ok(detail);
//    }
//
//    @Operation(summary = "启用/禁用知识库分类")
//    @PostMapping("/tag/update_status/{id}/{status}")
//    public ApiResponse<String> updateCategoryStatus(@Schema(description = "知识库分类ID") @PathVariable("id") Integer id,
//                                                    @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
//        examineService.updateWikiCategoryStatus(id, status);
//        return ApiResponse.ok("ok");
//    }
//
//    @Operation(summary = "删除知识库分类")
//    @PostMapping("/tag/delete/{id}")
//    public ApiResponse<String> deleteCategory(@Schema(description = "知识库分类ID") @PathVariable("id") Integer id) {
//        examineService.deleteWikiCategory(id);
//        return ApiResponse.ok("ok");
//    }
//
//    @Operation(summary = "保存知识库分类")
//    @PostMapping("/tag/save")
//    public ApiResponse<String> saveOrUpdateCategory(@RequestBody WikiCategorySaveDto dto) {
//        examineService.saveWikiCategory(dto);
//        return ApiResponse.ok("ok");
//    }
//
//    @Operation(summary = "知识库分类列表")
//    @GetMapping("/tag/list]")
//    public ApiResponse<PageResult<WikiCategoryDto>> categoryList(@QueryParam WikiCategoryRequestDto request) {
//        PageResult<WikiCategoryDto> pageResult = examineService.wikiCategoryPaginQuery(request);
//        return ApiResponse.ok(pageResult);
//    }
}
