package cn.breeze.elleai.controller.extension;

import cn.breeze.elleai.application.service.AiPlatformExtensionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author yangyw
 */
@RestController
@RequestMapping(value = "/extension")
@Tag(name = "扩展接口-AI平台扩展")
@RequiredArgsConstructor
public class AiPlatformExtensionController {

    private final AiPlatformExtensionService extensionService;


    @Operation(summary = "同音转换")
    @PostMapping(value = "/word_switch")
    public String wordSwitch(@RequestParam("query") String query) {
        return extensionService.wordSwitch(query);
    }


    @Operation(summary = "向量搜索")
    @PostMapping(value = "/vector_search")
    public String vectorSearch(@RequestParam("query") String query,
                               @RequestParam(value = "assistant_id", required = false, defaultValue = "0") Integer assistantId,
                               @RequestParam(value = "top_k", required = false, defaultValue = "5") Integer topK,
                               @RequestParam(value = "score", required = false, defaultValue = "0") Double score) {

        return extensionService.vectorSearch(query, assistantId, topK, score);
    }


    @Operation(summary = "向量搜索")
    @PostMapping(value = "/vector_search_with_rerank")
    public String vectorSearchWithRerank(@RequestParam("query") String query,
                               @RequestParam(value = "assistant_id", required = false, defaultValue = "0") Integer assistantId,
                               @RequestParam(value = "top_k", required = false, defaultValue = "5") Integer topK,
                               @RequestParam(value = "score", required = false, defaultValue = "0") Double score,
                                         @RequestParam(value = "rerank_top_k", required = false, defaultValue = "5") Integer rerankTopK,
                                         @RequestParam(value = "rerank_score", required = false, defaultValue = "0") Double rerankScore) {

        return extensionService.vectorSearchWithRerank(query, assistantId, topK, score, rerankTopK, rerankScore);
    }

}
