package cn.breeze.elleai.controller.front;

import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.util.UserPrincipal;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

@Controller
@RequestMapping(value = "/front/user")
@Tag(name = "移动端-用户&授权")
@RequiredArgsConstructor
@Slf4j
public class UserMobileController {

    @Value("${sso.user.mock:true}")
    private String enableMock;

    @Value("${sso.domain:}")
    private String ssoBaseUrl;

    @Operation(summary = "单点登录")
    @GetMapping("/sso")
    public void userSSOLogin(@RequestParam("jwt") String token, HttpServletResponse response) {
        if (StrUtil.isNotBlank(token)) {
            log.info("单点登录:{}", token);
            try {
                Cookie jwt = new Cookie("jwt", token);
                jwt.setPath("/");
                jwt.setHttpOnly(true);
                response.addCookie(jwt);
                response.sendRedirect(ssoBaseUrl + "/elle-coaching/1.0.0/index.html");
            } catch (IOException e) {
                log.error("单点登录异常{}", ExceptionUtil.getMessage(e));
            }
        }

    }

    @Operation(summary = "获取token")
    @GetMapping("/get_token")
    public @ResponseBody ApiResponse<String> getToken(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (ArrayUtil.isNotEmpty(cookies)) {
            Cookie cookie = ArrayUtil.firstMatch(c -> StrUtil.equals(c.getName(), "jwt"), cookies);
            if (ObjectUtil.isNotNull(cookie)) {
                return ApiResponse.ok(cookie.getValue());
            }
        }
        if (StrUtil.equals(enableMock, "true")) {
            return ApiResponse.ok("eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJqb2JUaXRsZSI6IuengeS6uumhvumXriIsImlzcyI6Im9zcyIsInNob3BOYW1lIjoi5p2P5Z2b5a6P5rGH5Z-O5bqXIiwicG9zaXRpb24iOiLpob7pl64iLCJzaG9wSWQiOiIwMDAwMDAwMDZlODY2OTVlMDE2ZTg2ZDJiYTkyMDAwOCIsInVzZXJOYW1lIjoiTTAwODg3NyIsImV4cCI6MTgxMTY3NDQ5NCwidXNlcklkIjoiMDAwMDAwMDA2MmQ3NWRiNTAxNjJkNzc1YjYxOTAwMGEifQ.4XCYKRVuHTaP3TYob7O31bpPnhoBQ9XSq1inM93IqYE");
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return ApiResponse.fail(401, "登录失败");

    }


    @Operation(summary = "获取用户信息")
    @GetMapping("/info")
    public @ResponseBody ApiResponse<UserPrincipal> getUserInfo(UserPrincipal userPrincipal) {
        return ApiResponse.ok(userPrincipal);
    }

}
