package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.QaAssistantRequestDto;
import cn.breeze.elleai.application.dto.response.HotQaMobileDto;
import cn.breeze.elleai.domain.sparring.model.request.KbRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.KbResponseModel;
import cn.breeze.elleai.infra.entity.KbEntity;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.service.IService;

import java.util.List;

/**
 *  服务层。
 *
 * @author breeze
 * @since 2024-10-21
 */
public interface KbService extends IService<KbEntity> {
    /***************************************** 知识库QA *****************************************/
    Page<KbResponseModel> kbPaginQuery(KbRequestModel request);

    List<KbResponseModel> kbList(KbRequestModel request);

    List<KbResponseModel> kbList(List<Integer> kbIds);

    KbResponseModel kbDetail(Integer id);

    void updateKbStatus(Integer id, Integer status);

    void deleteKb(Integer id);

    void saveKb(KbSaveModel dto);

    /**
     * 更新热门问题
     * @param vectorIds
     */
    void updateHotQuestion(List<String> vectorIds);

    PageResult<HotQaMobileDto> hotQaList(QaAssistantRequestDto request);
}
