package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.KbRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbSaveModel;
import cn.breeze.elleai.domain.sparring.model.request.KbTagRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbTagSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.KbResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.KbTagResponseModel;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.service.IService;
import cn.breeze.elleai.infra.entity.KbTagEntity;

import java.util.List;

/**
 *  服务层。
 *
 * @author breeze
 * @since 2024-10-21
 */
public interface KbTagService extends IService<KbTagEntity> {

    /***************************************** 知识库分类 *****************************************/
    Page<KbTagResponseModel> kbTagPaginQuery(KbTagRequestModel request);

    List<KbTagResponseModel> kbTagList(KbTagRequestModel request);

    List<KbTagResponseModel> kbTagList(List<Integer> tagIdList);

    KbTagResponseModel kbTagDetail(Integer id);

    void updateKbTagStatus(Integer id, Integer status);

    void deleteKbTag(Integer id);

    void saveKbTag(KbTagSaveModel dto);
}
