package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.KbTagRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbTagSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.KbTagResponseModel;
import cn.breeze.elleai.infra.entity.KbTagEntity;
import cn.breeze.elleai.infra.mapper.KbTagMapper;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.UpdateChain;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

import static cn.breeze.elleai.infra.entity.table.KbTagTableDef.KB_TAG_ENTITY;

/**
 *  服务层实现。
 *
 * @author breeze
 * @since 2024-10-21
 */
@Service
@RequiredArgsConstructor
public class KbTagServiceImpl extends ServiceImpl<KbTagMapper, KbTagEntity> implements KbTagService {
    private final KbTagMapper kbTagMapper;

    @Override
    public Page<KbTagResponseModel> kbTagPaginQuery(KbTagRequestModel request) {
        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_TAG_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.and(KB_TAG_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        if(Objects.nonNull(request.getStatus())) {
            queryWrapper.and(KB_TAG_ENTITY.STATUS.eq(request.getStatus()));
        }
        queryWrapper.orderBy(KB_TAG_ENTITY.CREATE_AT, false);

        Page<KbTagResponseModel> page = kbTagMapper.paginateAs(pageNo, pageSize, queryWrapper, KbTagResponseModel.class);

        return page;
    }

    @Override
    public List<KbTagResponseModel> kbTagList(KbTagRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_TAG_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.and(KB_TAG_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        if(Objects.nonNull(request.getStatus())) {
            queryWrapper.and(KB_TAG_ENTITY.STATUS.eq(request.getStatus()));
        }
        queryWrapper.orderBy(KB_TAG_ENTITY.CREATE_AT, false);

        return kbTagMapper.selectListByQueryAs(queryWrapper, KbTagResponseModel.class);
    }

    @Override
    public List<KbTagResponseModel> kbTagList(List<Integer> tagIdList) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_TAG_ENTITY.ID.in(tagIdList).and(KB_TAG_ENTITY.DELETED.eq(0)));
        return kbTagMapper.selectListByQueryAs(queryWrapper, KbTagResponseModel.class);
    }

    @Override
    public KbTagResponseModel kbTagDetail(Integer id) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_TAG_ENTITY.ID.eq(id).and(KB_TAG_ENTITY.DELETED.eq(0)));
        return kbTagMapper.selectOneByQueryAs(queryWrapper, KbTagResponseModel.class);
    }

    @Override
    public void updateKbTagStatus(Integer id, Integer status) {
        UpdateChain.of(KbTagEntity.class)
                .set(KB_TAG_ENTITY.STATUS, status)
                .where(KB_TAG_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void deleteKbTag(Integer id) {
        UpdateChain.of(KbTagEntity.class)
                .set(KB_TAG_ENTITY.DELETED, 1)
                .where(KB_TAG_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void saveKbTag(KbTagSaveModel dto) {
        KbTagEntity entity = BeanUtil.toBean(dto, KbTagEntity.class);
        if(Objects.isNull(entity.getId())) {
            entity.setStatus(0);
            entity.setDeleted(0);
        }
        kbTagMapper.insertOrUpdateSelective(entity);
    }
}
