package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.KbVectorRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbVectorSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.KbVectorResponseModel;
import cn.breeze.elleai.infra.entity.KbVectorEntity;
import cn.breeze.elleai.infra.mapper.KbVectorMapper;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import static cn.breeze.elleai.infra.entity.table.KbVectorTableDef.KB_VECTOR_ENTITY;

/**
 *  服务层实现。
 *
 * @author breeze
 * @since 2024-10-21
 */
@Service
@RequiredArgsConstructor
public class KbVectorServiceImpl extends ServiceImpl<KbVectorMapper, KbVectorEntity> implements KbVectorService {

    private final KbVectorMapper kbVectorMapper;

    @Override
    public Page<KbVectorResponseModel> kbVectorPaginQuery(KbVectorRequestModel request) {
        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create();
        if(Objects.nonNull(request.getKbId())) {
            queryWrapper.and(KB_VECTOR_ENTITY.KB_ID.eq(request.getKbId()));
        }
        queryWrapper.orderBy(KB_VECTOR_ENTITY.CREATE_AT, false);

        Page<KbVectorResponseModel> page = kbVectorMapper.paginateAs(pageNo, pageSize, queryWrapper, KbVectorResponseModel.class);

        return page;
    }

    @Override
    public List<KbVectorResponseModel> kbVectorList(KbVectorRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if(Objects.nonNull(request.getKbId())) {
            queryWrapper.and(KB_VECTOR_ENTITY.KB_ID.eq(request.getKbId()));
        }
        queryWrapper.orderBy(KB_VECTOR_ENTITY.CREATE_AT, false);

        return kbVectorMapper.selectListByQueryAs(queryWrapper, KbVectorResponseModel.class);
    }

    @Override
    public KbVectorResponseModel kbVectorDetail(Integer kbId) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_VECTOR_ENTITY.KB_ID.eq(kbId));
        return kbVectorMapper.selectOneByQueryAs(queryWrapper, KbVectorResponseModel.class);
    }

    @Override
    public void deleteKbVector(Integer kbId) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(KB_VECTOR_ENTITY.KB_ID.eq(kbId));
        kbVectorMapper.deleteByQuery(queryWrapper);
    }

    @Override
    public void saveKbVector(KbVectorSaveModel dto) {
        KbVectorEntity entity = BeanUtil.toBean(dto, KbVectorEntity.class);
        if(Objects.isNull(entity.getId())) {
            entity.setCreateAt(new Date());
        }
        kbVectorMapper.insertOrUpdateSelective(entity);
    }

    @Override
    public void batchSaveKbVector(List<KbVectorSaveModel> list) {
        List<KbVectorEntity> kbVectorEntities = BeanUtil.copyToList(list, KbVectorEntity.class);
        kbVectorMapper.insertBatchSelective(kbVectorEntities);
    }
}
