package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.KbVectorRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.KbVectorSaveModel;
import cn.breeze.elleai.domain.sparring.model.request.WikiUserViewSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.KbVectorResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.WikiUserViewResponseModel;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.service.IService;
import cn.breeze.elleai.infra.entity.WikiUserViewEntity;

import java.util.List;

/**
 *  服务层。
 *
 * @author breeze
 * @since 2024-10-24
 */
public interface WikiUserViewService extends IService<WikiUserViewEntity> {
    /***************************************** 知识库集合 *****************************************/

    List<WikiUserViewResponseModel> viewList(String userId);

    WikiUserViewResponseModel viewDetail(String userId, Integer wikiId);

    void saveView(WikiUserViewSaveModel dto);
}
