package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.WikiUserViewSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.WikiUserViewResponseModel;
import cn.breeze.elleai.infra.entity.WikiUserViewEntity;
import cn.breeze.elleai.infra.mapper.WikiUserViewMapper;
import cn.hutool.core.bean.BeanUtil;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import static cn.breeze.elleai.infra.entity.table.WikiUserViewTableDef.WIKI_USER_VIEW_ENTITY;

/**
 *  服务层实现。
 *
 * @author breeze
 * @since 2024-10-24
 */
@Service
public class WikiUserViewServiceImpl extends ServiceImpl<WikiUserViewMapper, WikiUserViewEntity> implements WikiUserViewService {
    @Override
    public List<WikiUserViewResponseModel> viewList(String userId) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(WIKI_USER_VIEW_ENTITY.USER_ID.eq(userId));
        queryWrapper.orderBy(WIKI_USER_VIEW_ENTITY.CREATE_TIME, false);

        return mapper.selectListByQueryAs(queryWrapper, WikiUserViewResponseModel.class);
    }

    @Override
    public void saveView(WikiUserViewSaveModel dto) {
        WikiUserViewEntity entity = BeanUtil.toBean(dto, WikiUserViewEntity.class);
        if(Objects.isNull(entity.getId())) {
            entity.setCreateTime(new Date());
        }
        mapper.insertOrUpdateSelective(entity);
    }

    @Override
    public WikiUserViewResponseModel viewDetail(String userId, Integer wikiId) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(WIKI_USER_VIEW_ENTITY.USER_ID.eq(userId));
        queryWrapper.and(WIKI_USER_VIEW_ENTITY.WIKI_ID.eq(wikiId));
        return mapper.selectOneByQueryAs(queryWrapper, WikiUserViewResponseModel.class);
    }
}
