package cn.breeze.elleai.domain.system.service;

import cn.breeze.elleai.domain.sparring.model.response.KbVectorResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.SysUserResponseModel;
import cn.breeze.elleai.infra.entity.SysUserEntity;
import cn.breeze.elleai.infra.mapper.SysUserMapper;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import static cn.breeze.elleai.infra.entity.table.SysUserTableDef.SYS_USER_ENTITY;

/**
 *  服务层实现。
 *
 * @author breeze
 * @since 2024-10-21
 */
@Service
@RequiredArgsConstructor
public class SysUserServiceImpl extends ServiceImpl<SysUserMapper, SysUserEntity> implements SysUserService {

    private final SysUserMapper sysUserMapper;

    @Override
    public SysUserResponseModel findByUsername(String username) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(SYS_USER_ENTITY.USERNAME.eq(username));
        return sysUserMapper.selectOneByQueryAs(queryWrapper, SysUserResponseModel.class);
    }
}
