package cn.breeze.elleai.facade;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.milvus.MilvusEmbeddingStore;
import jakarta.annotation.PostConstruct;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author yangyw
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class MilvusVectorStoreFacade implements VectorStoreService {

    @Value("${milvus.host:172.18.5.186}")
    private String host;

    @Value("${milvus.port:31530}")
    private Integer port;

    @Value("${milvus.database:falcon}")
    private String database;

    @Value("${milvus.dimension:1024}")
    private Integer dimension;

    @Value("${milvus.collection:elle_embedding_store}")
    private String collection;

    private EmbeddingStore<TextSegment> embeddingStore;

    @PostConstruct
    protected void init() {
        log.info("开始链接milvus向量数据库:{}:{}", host, port);
        embeddingStore = MilvusEmbeddingStore.builder()
                .host(host)
                .dimension(dimension)
                .collectionName(collection)
                .databaseName(database)
                .port(port)
                .build();
        log.info("milvus链接成功");
    }

    @Override
    public EmbeddingStore<TextSegment> getEmbeddingStore() {
        return embeddingStore;
    }
}
