package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.Date;

import java.io.Serial;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-09-18
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("ai_examine")
public class ExamineEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Integer id;

    /**
     * 对练名称
     */
    private String name;

    /**
     * 对练描述
     */
    private String description;

    /**
     * 海报图
     */
    private String poster;

    /**
     * 对练场景ID
     */
    private Integer sceneId;

    /**
     * 对练分类ID
     */
    private Integer categoryId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 题目数量
     */
    private Integer qaNum;

    /**
     * 是否删除（0否 1是）
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

}
