package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.Date;

import java.io.Serial;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-10-21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("cs_kb_tag")
public class KbTagEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Long id;

    /**
     * 分类名称
     */
    private String name;

    private String description;

    /**
     * 状态0停用，1启用
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createAt;

    /**
     * 父级ID（1级为0）
     */
    private Long parentId;

    /**
     * 是否删除
     */
    private Integer deleted;

}
