package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.Date;

import java.io.Serial;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-10-21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("cs_kb_vector")
public class KbVectorEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Long id;

    /**
     * 知识ID
     */
    private Integer kbId;

    /**
     * 向量知识库数据ID
     */
    private String vectorId;

    /**
     * 创建时间
     */
    private Date createAt;

}
