package cn.breeze.elleai.infra.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-09-18
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("ai_user_chat_completion")
public class UserChatCompletionEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Integer id;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 所属门店ID
     */
    private String shopId;

    /**
     * 所属门店名称
     */
    private String shopName;

    /**
     * 会话ID
     */
    private String sessionId;

    /**
     * 首次提问时间
     */
    private String firstQuestion;

    /**
     * 最后一次提问
     */
    private String lastQuestion;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date updateTime;

}
