package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-09-18
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("ai_user_chat_completion_history")
public class UserChatCompletionHistoryEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Integer id;

    /**
     * 会话ID
     */
    private Integer chatCompletionId;

    /**
     * 类型（0用户提问 1AI回答）
     */
    private Integer type;

    /**
     * 问答助手ID
     */
    private Integer assistantId;

    /**
     * 内容
     */
    private String content;

    /**
     * 创建时间
     */
    private Date createTime;

}
