package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ExamineEvaluateJobTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public static final ExamineEvaluateJobTableDef EXAMINE_EVALUATE_JOB_ENTITY = new ExamineEvaluateJobTableDef();


    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 业务ID（单题点评为详情记录ID，总点评为考试记录ID）
     */
    public final QueryColumn BUSINESS_ID = new QueryColumn(this, "business_id");

    /**
     * 类型（0单题点评 1总点评）
     */
    public final QueryColumn TYPE = new QueryColumn(this, "type");

    /**
     * 考试流水号
     */
    public final QueryColumn BUSINESS_NO = new QueryColumn(this, "business_no");

    /**
     * 用户ID
     */
    public final QueryColumn USER_ID = new QueryColumn(this, "user_id");

    /**
     * 状态（0待执行 1执行成功）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 执行失败原因
     */
    public final QueryColumn FAIL_REASON = new QueryColumn(this, "fail_reason");


    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
        public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, BUSINESS_ID, TYPE, USER_ID, BUSINESS_NO, STATUS, FAIL_REASON, CREATE_TIME, UPDATE_TIME};

    public ExamineEvaluateJobTableDef() {
        super("", "ai_examine_evaluate_job");
    }

    private ExamineEvaluateJobTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ExamineEvaluateJobTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ExamineEvaluateJobTableDef("", "ai_examine_evaluate_job", alias));
    }

}
