package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ExamineTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final ExamineTableDef EXAMINE_ENTITY = new ExamineTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 对练名称
     */
    public final QueryColumn NAME = new QueryColumn(this, "name");

    /**
     * 题目数量
     */
    public final QueryColumn QA_NUM = new QueryColumn(this, "qa_num");

    /**
     * 海报图
     */
    public final QueryColumn POSTER = new QueryColumn(this, "poster");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 结束时间
     */
    public final QueryColumn END_TIME = new QueryColumn(this, "end_time");

    /**
     * 对练场景ID
     */
    public final QueryColumn SCENE_ID = new QueryColumn(this, "scene_id");

    /**
     * 开始时间
     */
    public final QueryColumn START_TIME = new QueryColumn(this, "start_time");

    /**
     * 对练分类ID
     */
    public final QueryColumn CATEGORY_ID = new QueryColumn(this, "category_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 对练描述
     */
    public final QueryColumn DESCRIPTION = new QueryColumn(this, "description");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, NAME, DESCRIPTION, POSTER, SCENE_ID, CATEGORY_ID, START_TIME, END_TIME, STATUS, QA_NUM, DELETED, CREATE_TIME, UPDATE_TIME};

    public ExamineTableDef() {
        super("", "ai_examine");
    }

    private ExamineTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ExamineTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ExamineTableDef("", "ai_examine", alias));
    }

}
