package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-10-21
 */
public class KbTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final KbTableDef KB_ENTITY = new KbTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 知识分类ID
     */
    public final QueryColumn TAG_ID = new QueryColumn(this, "tag_id");

    /**
     * 答案
     */
    public final QueryColumn ANSWER = new QueryColumn(this, "answer");

    /**
     * 状态0停用，1启用
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 删除标识，0有效，1删除
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 统计次数
     */
    public final QueryColumn HINT = new QueryColumn(this, "hint");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_AT = new QueryColumn(this, "create_at");

    /**
     * 问题
     */
    public final QueryColumn QUESTION = new QueryColumn(this, "question");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_AT = new QueryColumn(this, "update_at");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, TAG_ID, HINT, QUESTION, ANSWER, STATUS, DELETED, CREATE_AT, UPDATE_AT};

    public KbTableDef() {
        super("", "cs_kb");
    }

    private KbTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public KbTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new KbTableDef("", "cs_kb", alias));
    }

}
