package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-10-21
 */
public class KbVectorTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final KbVectorTableDef KB_VECTOR_ENTITY = new KbVectorTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 知识ID
     */
    public final QueryColumn KB_ID = new QueryColumn(this, "kb_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_AT = new QueryColumn(this, "create_at");

    /**
     * 向量知识库数据ID
     */
    public final QueryColumn VECTOR_ID = new QueryColumn(this, "vector_id");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, KB_ID, VECTOR_ID, CREATE_AT};

    public KbVectorTableDef() {
        super("", "cs_kb_vector");
    }

    private KbVectorTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public KbVectorTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new KbVectorTableDef("", "cs_kb_vector", alias));
    }

}
