package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class QaAssistantTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final QaAssistantTableDef QA_ASSISTANT_ENTITY = new QaAssistantTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 助手名称
     */
    public final QueryColumn NAME = new QueryColumn(this, "name");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 助手图标
     */
    public final QueryColumn ICON_URL = new QueryColumn(this, "icon_url");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 知识库分类ID列表
     */
    public final QueryColumn CATEGORY_IDS = new QueryColumn(this, "category_ids");

    /**
     * 助手描述
     */
    public final QueryColumn DESCRIPTION = new QueryColumn(this, "description");

    /**
     * 可见角色列表
     */
    public final QueryColumn VISIBLE_ROLE_IDS = new QueryColumn(this, "visible_role_ids");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, NAME, DESCRIPTION, ICON_URL, CATEGORY_IDS, VISIBLE_ROLE_IDS, STATUS, DELETED, CREATE_TIME, UPDATE_TIME};

    public QaAssistantTableDef() {
        super("", "ai_qa_assistant");
    }

    private QaAssistantTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public QaAssistantTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new QaAssistantTableDef("", "ai_qa_assistant", alias));
    }

}
