package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class SysUserTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public static final SysUserTableDef SYS_USER_ENTITY = new SysUserTableDef();


    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 系统用户编号
     */
    public final QueryColumn USERNAME = new QueryColumn(this, "username");

    /**
     * 手机号
     */
    public final QueryColumn MOBILE = new QueryColumn(this, "mobile");

    /**
     * 邮箱
     */
    public final QueryColumn EMAIL = new QueryColumn(this, "email");

    /**
     * 手机号
     */
    public final QueryColumn PASSWORD = new QueryColumn(this, "password");


    /**
     * 昵称
     */
    public final QueryColumn NICKNAME = new QueryColumn(this, "nick_name");

    /**
     * 头像
     */
    public final QueryColumn AVATAR = new QueryColumn(this, "avatar");

    /**
     *
     */
    public final QueryColumn SALT = new QueryColumn(this, "salt");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_AT = new QueryColumn(this, "create_at");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_AT = new QueryColumn(this, "update_at");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, USERNAME, MOBILE, EMAIL, PASSWORD, NICKNAME, AVATAR, SALT, STATUS, DELETED, CREATE_AT, UPDATE_AT};

    public SysUserTableDef() {
        super("", "sys_user");
    }

    private SysUserTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public SysUserTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new SysUserTableDef("", "sys_user", alias));
    }

}
