package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class UserChatCompletionHistoryTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final UserChatCompletionHistoryTableDef USER_CHAT_COMPLETION_HISTORY_ENTITY = new UserChatCompletionHistoryTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 类型（0用户提问 1AI回答）
     */
    public final QueryColumn TYPE = new QueryColumn(this, "type");

    /**
     * 会话ID
     */
    public final QueryColumn CHAT_COMPLETION_ID = new QueryColumn(this, "chat_completion_id");

    /**
     * 内容
     */
    public final QueryColumn CONTENT = new QueryColumn(this, "content");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, CHAT_COMPLETION_ID, TYPE, CONTENT, CREATE_TIME};

    public UserChatCompletionHistoryTableDef() {
        super("", "ai_user_chat_completion_history");
    }

    private UserChatCompletionHistoryTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public UserChatCompletionHistoryTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new UserChatCompletionHistoryTableDef("", "ai_user_chat_completion_history", alias));
    }

}
