package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class UserChatCompletionTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public static final UserChatCompletionTableDef USER_CHAT_COMPLETION_ENTITY = new UserChatCompletionTableDef();


    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 类型（0用户提问 1AI回答）
     */
    public final QueryColumn TYPE = new QueryColumn(this, "type");

    /**
     * 用户ID
     */
    public final QueryColumn USER_ID = new QueryColumn(this, "user_id");

    /**
     * 用户名称
     */
    public final QueryColumn USER_NAME = new QueryColumn(this, "user_name");

    /**
     * 所属门店ID
     */
    public final QueryColumn SHOP_ID = new QueryColumn(this, "shop_id");

    /**
     * 所属门店名称
     */
    public final QueryColumn SHOP_NAME = new QueryColumn(this, "shop_name");

    /**
     * DIFY会话ID
     */
    public final QueryColumn SESSION_ID = new QueryColumn(this, "session_id");

    /**
     * 内容
     */
    public final QueryColumn CONTENT = new QueryColumn(this, "content");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 最后更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, USER_ID, USER_NAME, SHOP_ID, SHOP_NAME, SESSION_ID, TYPE, CONTENT, CREATE_TIME, UPDATE_TIME};

    public UserChatCompletionTableDef() {
        super("", "ai_user_chat_completion");
    }

    private UserChatCompletionTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public UserChatCompletionTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new UserChatCompletionTableDef("", "ai_user_chat_completion", alias));
    }

}
