package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class UserExamineRecordTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final UserExamineRecordTableDef USER_EXAMINE_RECORD_ENTITY = new UserExamineRecordTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 用户ID
     */
    public final QueryColumn USER_ID = new QueryColumn(this, "user_id");

    /**
     * 用户名称
     */
    public final QueryColumn USER_NAME = new QueryColumn(this, "user_name");

    /**
     * 考试流水号
     */
    public final QueryColumn BUSINESS_NO = new QueryColumn(this, "business_no");


    /**
     * 所属门店ID
     */
    public final QueryColumn SHOP_ID = new QueryColumn(this, "shop_id");

    /**
     * 所属门店名称
     */
    public final QueryColumn SHOP_NAME = new QueryColumn(this, "shop_name");

    /**
     * 对练ID
     */
    public final QueryColumn EXAMINE_ID = new QueryColumn(this, "examine_id");

    /**
     * 会话ID
     */
    public final QueryColumn SESSION_ID = new QueryColumn(this, "session_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 已答题数量
     */
    public final QueryColumn ANSWERED_NUM = new QueryColumn(this, "answered_num");

    /**
     * 对练模式（0练习 1对练）
     */
    public final QueryColumn EXAMINE_MODE = new QueryColumn(this, "examine_mode");

    /**
     * 综合评分
     */
    public final QueryColumn OVERALL_SCORE = new QueryColumn(this, "overall_score");

    /**
     * 综合评价
     */
    public final QueryColumn OVERALL_EVALUATION = new QueryColumn(this, "overall_evaluation");

    /**
     * 综合评价
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, USER_ID, USER_NAME, BUSINESS_NO, SHOP_ID, SHOP_NAME, SESSION_ID, EXAMINE_ID, EXAMINE_MODE, ANSWERED_NUM, OVERALL_SCORE, OVERALL_EVALUATION, CREATE_TIME, UPDATE_TIME, DELETED};

    public UserExamineRecordTableDef() {
        super("", "ai_user_examine_record");
    }

    private UserExamineRecordTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public UserExamineRecordTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new UserExamineRecordTableDef("", "ai_user_examine_record", alias));
    }

}
