package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class WikiTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final WikiTableDef WIKI_ENTITY = new WikiTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 资料名称
     */
    public final QueryColumn NAME = new QueryColumn(this, "name");

    /**
     * 富文本详情
     */
    public final QueryColumn DETAIL = new QueryColumn(this, "detail");

    /**
     * 资料海报图
     */
    public final QueryColumn POSTER = new QueryColumn(this, "poster");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 资料文件URL
     */
    public final QueryColumn FILE_URL = new QueryColumn(this, "file_url");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 资料描述
     */
    public final QueryColumn DESCRIPTION = new QueryColumn(this, "description");

    /**
     * 资料分类ID
     */
    public final QueryColumn WIKI_CATEGORY_ID = new QueryColumn(this, "wiki_category_id");

    /**
     * 场景分类ID
     */
    public final QueryColumn SCENE_CATEGORY_ID = new QueryColumn(this, "scene_category_id");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, NAME, DESCRIPTION, POSTER, FILE_URL, WIKI_CATEGORY_ID, SCENE_CATEGORY_ID, DETAIL, STATUS, DELETED, CREATE_TIME, UPDATE_TIME};

    public WikiTableDef() {
        super("", "ai_wiki");
    }

    private WikiTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public WikiTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new WikiTableDef("", "ai_wiki", alias));
    }

}
