package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-10-24
 */
public class WikiUserViewTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final WikiUserViewTableDef WIKI_USER_VIEW_ENTITY = new WikiUserViewTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 用户ID
     */
    public final QueryColumn USER_ID = new QueryColumn(this, "user_id");

    /**
     * 资料ID
     */
    public final QueryColumn WIKI_ID = new QueryColumn(this, "wiki_id");

    /**
     * 浏览次数
     */
    public final QueryColumn VIEW_COUNT = new QueryColumn(this, "view_count");

    
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, WIKI_ID, USER_ID, VIEW_COUNT, CREATE_TIME};

    public WikiUserViewTableDef() {
        super("", "ai_wiki_user_view");
    }

    private WikiUserViewTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public WikiUserViewTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new WikiUserViewTableDef("", "ai_wiki_user_view", alias));
    }

}
