package cn.breeze.elleai.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

import java.util.*;

/**
 * @author qx
 * @date 2023/7/4
 * @des JWT工具类
 */
public class JwtUtil {

    public static UserPrincipal checkAndTransformV2(String token) {
        Algorithm algorithm = Algorithm.HMAC256("mezeron-ai");
        JWTVerifier verifier = com.auth0.jwt.JWT.require(algorithm)
                .withIssuer("oss")
                .build();
        DecodedJWT jwt = verifier.verify(token);

        String userId =  jwt.getClaim("userId").asString();
        String userName = jwt.getClaim("userName").asString();
        String position = jwt.getClaim("position").asString();
        String shopId = jwt.getClaim("shopId").asString();
        String shopName = jwt.getClaim("shopName").asString();
        String jobTitle = jwt.getClaim("jobTitle").asString();

        UserPrincipal principal = new UserPrincipal();
        principal.setUserId(userId);
        principal.setUserName(userName);
        principal.setPosition(position);
        principal.setShopId(shopId);
        principal.setShopName(shopName);
        principal.setJobTitle(jobTitle);
        principal.setToken(token);
        return principal;
    }

    public static Mono<Authentication> convert(HttpServletRequest request) {
        return Mono.just(request).flatMap(ex -> {
            String token = null;

            String headerVal = request.getHeader("Authorization");
            if (StrUtil.isNotBlank(headerVal) && headerVal.startsWith("Bearer ")) {
                token = headerVal.substring(7);
            } else {
                Cookie[] cookies = request.getCookies();
                if (Objects.nonNull(cookies) && cookies.length > 0) {
                    Optional<Cookie> jwt = Arrays.stream(cookies).filter(v -> Objects.equals(v.getName(), "jwt")).findFirst();
                    if (jwt.isPresent()) {
                        token = jwt.get().getValue();
                    }
                }
            }
            return Mono.justOrEmpty(token);
        }).flatMap(token -> Mono.justOrEmpty(checkAndTransformV2(token))
                .map(payload -> {
                    if(ObjectUtil.isNull(payload)) {
                        //解密失败，jwt无效时返回为通过的授权
                        return UsernamePasswordAuthenticationToken.unauthenticated("", "");
                    } else {
                        //解密成功，jwt验证通过，返回授权
                        return UsernamePasswordAuthenticationToken.authenticated(payload, "", Collections.emptyList());
                    }
                }));
    }

    public static String generateToken(String userName, String password, Long userId) {
        String token = null;
        Long expireTime = 1000*24 * 60 * 60 * 1000L;
        Date expiresAt = new Date(System.currentTimeMillis()+ expireTime);
        token = JWT.create()
                .withIssuer("oss")
                .withClaim("userId", String.valueOf(userId))
                .withClaim("userName",userName)
                .withClaim( "position", "")
                .withClaim("jobTitle","")
                .withClaim( "shopId","")
                .withClaim( "shopName","")
                .withExpiresAt(expiresAt)
                .sign(Algorithm.HMAC256("mezeron-ai"));
        return token;
    }
}
