package cn.breeze.elleai.util;

import cn.breeze.elleai.application.dto.inner.PinYin;
import cn.breeze.elleai.application.dto.inner.Term;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yangyw
 */
public class PinYinUtils {


    /**
     * 将内容的汉字转换为拼音
     * @param hans
     * @return
     */
    public static String hansToPinYin(String hans) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder sb = new StringBuilder();
        char[] chars = hans.toCharArray();
        for (char c : chars) {
            if (Character.isWhitespace(c)) {
                continue;
            }
            if (c >= '\u4e00' && c <= '\u9fa5') {
                try {
                    String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(c, format);
                    sb.append(pinyinArray[0]);
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }


    /**
     * 将内容的汉字转换为拼音
     * @param hans
     * @return
     */
    public static PinYin hansToPinYinObj(String hans) {
        PinYin pinYin = new PinYin();
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        List<Term> terms = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        char[] chars = hans.toCharArray();
        for (char c : chars) {
            Term  term = new Term();
            if (Character.isWhitespace(c)) {
                term.setHans(String.valueOf(c));
                term.setPinyin("");
                terms.add(term);
                continue;
            }
            if (c >= '\u4e00' && c <= '\u9fa5') {
                try {
                    String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(c, format);
                    term.setHans(String.valueOf(c));
                    term.setPinyin(pinyinArray[0]);
                    terms.add(term);
                    sb.append(pinyinArray[0]);
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                sb.append(c);
            }
        }
        pinYin.setSentence(hans);
        pinYin.setPinyin(sb.toString());
        pinYin.setTerms(terms);
        return pinYin;
    }

}
